package com.example.myapplication

import android.os.Bundle
import android.view.View
import android.widget.ImageButton
import android.widget.TableRow
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import kotlinx.android.synthetic.main.ticktacktoo.*

class MainActivity: AppCompatActivity(), View.OnClickListener {
    lateinit var squares:Squares
    var next:Boolean = true
    var isFinal = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.ticktacktoo)

        var imagebutton = arrayOf(
            arrayOf(imageButton1,imageButton2,imageButton3),
            arrayOf(imageButton4,imageButton5,imageButton6),
            arrayOf(imageButton7,imageButton8,imageButton9)
        )

        for(idx1 in imagebutton.indices){
            for(idx2 in imagebutton[idx1].indices){
                imagebutton[idx1][idx2].setOnClickListener(this)
                var array = arrayOf(idx1,idx2)
                imagebutton[idx1][idx2].setTag(array)
            }
        }
        button.setOnClickListener(this)
        squares = Squares(imagebutton)
        init()
    }

    override fun onClick(p0: View?) {
        when (p0!!.id) {
            R.id.button -> buttonClick()
            else -> imagebuttonClick(p0)
        }
    }

    fun imagebuttonClick(p0: View?){
        if(isFinal){                                //試合終了なら処理しない
            return
        }
        var button = p0 as ImageButton
        var array  = button.getTag() as Array<Int>
        textView3.text = ""
        if(squares.isKUHAKU(array[0],array[1])){
            squares.click(array[0], array[1], next)
            var win = squares.jug()                 //終了判定処理呼び出し
            if(win != Const.KUHAKU){                //試合終了なら終了処理呼び出し
                final(win)
            }
            next = !next
        }else {
            textView3.text = getString(R.string.MSG_ALREADY)
        }
    }

    fun init(){
        squares.allClear()
        next = true;
        buttonSet()
    }

    fun buttonClick(){
        if(isFinal){    //START
            init()
            textView3.text=getString(R.string.MSG_PROMPT)
            isFinal = false
            buttonSet()
        }else{          //RESET
            createDialog()
        }
    }

    fun final(win:Int){
        textView3.text = resources.getStringArray(R.array.MSG_FINAL)[win]
        isFinal = true
        buttonSet()
    }

    fun buttonSet(){
        if(isFinal){
            button.text = getString(R.string.LABEL_START)
            button.setBackgroundResource(R.drawable.button_blue)
        }else{
            button.text = getString(R.string.LABEL_RESET)
            button.setBackgroundResource(R.drawable.button_red)

        }
    }

    fun createDialog(){
        AlertDialog.Builder(this)
            .setTitle("RESET?")
            .setMessage(getString(R.string.MSG_RESET_CONFIRT))
            .setPositiveButton(getString(R.string.LABEL_OK)) { dialog, which -> //OK選択時処理
                init()
                isFinal = true
                buttonSet()
            }
            .setNegativeButton(getString(R.string.LABEL_NO), { dialog, which ->//NO選択時処理（何もしない）
            })
            .show()
    }
}



